<?php

namespace Opencart\Catalog\Model\Setting;

/**
 * Class Module
 *
 * @package Opencart\Catalog\Model\Setting
 */
class Module extends \Opencart\System\Engine\Model
{
	/**
	 * @param int $module_id
	 *
	 * @return array
	 */
	public function getModule(int $module_id): array
	{
		// Menjalankan query untuk mengambil data dari tabel module
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "module` WHERE `module_id` = '" . (int)$module_id . "'");

		// Memeriksa apakah hasil query memiliki baris
		if ($query->row) {
			// Mengambil nilai setting dan meng-decode JSON
			$setting = json_decode($query->row['setting'], true);

			// Memastikan bahwa hasil json_decode adalah array, jika tidak, kembalikan array kosong
			if (is_array($setting)) {
				return $setting;
			} else {
				return [];
			}
		} else {
			return [];
		}
	}
}
