<?php
namespace Opencart\Admin\Controller\Extension\PurpletreeMultivendor\Multivendor;
class Producttemplate extends \Opencart\System\Engine\Controller {
		private $error = array();
		
		public function index() {
			$this->load->language('extension/purpletree_multivendor/multivendor/admintemplate');
			
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('catalog/product');
			if(!$this->config->get('module_purpletree_multivendor_seller_product_template')){
				$this->response->redirect($this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'] . $url, true));
			}
			$this->getList();
		}
		public function edit() {
			$this->load->language('extension/purpletree_multivendor/multivendor/admintemplate');
			
			$this->document->setTitle($this->language->get('heading_title'));
			
			$this->load->model('catalog/product');
			$this->load->model('extension/purpletree_multivendor/multivendor/vendor');
			
			if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
				$this->model_catalog_product->editProduct($this->request->get['product_id'], $this->request->post);
				$this->model_extension_purpletree_multivendor_multivendor_vendor->editAdmintemp($this->request->get['product_id'], $this->request->post);
				
				$this->session->data['success'] = $this->language->get('text_success');
				
				$url = '';
				
				if (isset($this->request->get['filter_name'])) {
					$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
				}
				
				if (isset($this->request->get['filter_model'])) {
					$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
				}
				
				if (isset($this->request->get['filter_status'])) {
					$url .= '&filter_status=' . $this->request->get['filter_status'];
				}
				if (isset($this->request->get['filter_price'])) {
					$url .= '&filter_price=' . $this->request->get['filter_price'];
				}		
				if (isset($this->request->get['filter_quantity'])) {
					$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
				}
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}
				
				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}
				
				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				
				$this->response->redirect($this->url->link('extension/purpletree_multivendor/multivendor/admintemplate', 'user_token=' . $this->session->data['user_token'] . $url, true));
			}
			
			$this->getForm();
		}
		
		public function delete() {
			$this->load->language('extension/purpletree_multivendor/multivendor/admintemplate');
			
			$this->document->setTitle($this->language->get('heading_title'));
			
			$this->load->model('catalog/product');
			$this->load->model('extension/purpletree_multivendor/multivendor/vendor');
			
			if (isset($this->request->post['selected']) && $this->validateDelete()) {
				foreach ($this->request->post['selected'] as $id) {	
				   $template_id = $this->model_extension_purpletree_multivendor_multivendor_vendor->getTemplateId1($id);
					$product_id = $this->model_extension_purpletree_multivendor_multivendor_vendor->getProductid($template_id);
					$temp_status = $this->model_extension_purpletree_multivendor_multivendor_vendor->checkTempstatus($product_id);
					$status1 = '';			
					if($temp_status == 1){
						   $status1 = 1;
						  $this->db->query("UPDATE " . DB_PREFIX . "product SET status = '" . (int)$status1 . "' WHERE product_id = '" . (int)$product_id . "'");
						  }else{
							$status1 = 0;
						  $this->db->query("UPDATE " . DB_PREFIX . "product SET status = '" . (int)$status1 . "' WHERE product_id = '" . (int)$product_id . "'");
						  }
					$this->model_extension_purpletree_multivendor_multivendor_vendor->deletesellertempProduct($id);
				}
				
				$this->session->data['success'] = $this->language->get('text_success');
				
				$url = '';
				
				if (isset($this->request->get['filter_name'])) {
					$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
				}
				
				if (isset($this->request->get['filter_model'])) {
					$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
				}
				if (isset($this->request->get['filter_status'])) {
					$url .= '&filter_status=' . $this->request->get['filter_status'];
				}
				if (isset($this->request->get['filter_price'])) {
					$url .= '&filter_price=' . $this->request->get['filter_price'];
				}
				if (isset($this->request->get['filter_quantity'])) {
					$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
				}
				
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}
				
				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}
				
				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				
				$this->response->redirect($this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . $url, true));
			}
			
			$this->getList();
		}
		
		protected function getList() {
			$this->document->addStyle('../extension/purpletree_multivendor/admin/view/javascript/purpletreecss/commonstylesheet.css');
			if (isset($this->request->get['filter_name'])) {
				$filter_name = $this->request->get['filter_name'];
				} else {
				$filter_name = '';
			}
			
			if (isset($this->request->get['filter_model'])) {
				$filter_model = $this->request->get['filter_model'];
				} else {
				$filter_model = '';
			}
			
			if (isset($this->request->get['filter_status'])) {
				$filter_status = $this->request->get['filter_status'];
				} else {
				$filter_status = '';
			}		
			if (isset($this->request->get['filter_store'])) {
				$filter_store = $this->request->get['filter_store'];
				} else {
				$filter_store = '';
			}
			if (isset($this->request->get['filter_price'])) {
				$filter_price = $this->request->get['filter_price'];
				} else {
				$filter_price = '';
			}		
			if (isset($this->request->get['filter_quantity'])) {
				$filter_quantity = $this->request->get['filter_quantity'];
				} else {
				$filter_quantity = '';
			}
			if (isset($this->request->get['sort'])) {
				$sort = $this->request->get['sort'];
				} else {
				$sort = 'pd.name';
			}
			
			if (isset($this->request->get['order'])) {
				$order = $this->request->get['order'];
				} else {
				$order = 'ASC';
			}
			
			if (isset($this->request->get['page'])) {
				$page = $this->request->get['page'];
				} else {
				$page = 1;
			}
			
			$url = '';
			
			if (isset($this->request->get['filter_store'])) {
				$url .= '&filter_store=' . urlencode(html_entity_decode($this->request->get['filter_store'], ENT_QUOTES, 'UTF-8'));
			}		
			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}
			
			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
			}
			
			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}
			if (isset($this->request->get['filter_price'])) {
				$url .= '&filter_price=' . $this->request->get['filter_price'];
			}		
			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
			}
			
			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			///Help code///	
			//$data['helplink'] = "https://www.purpletreesoftware.com/knowledgebase/tag/opencart-multivendor-seller-template-product";
			$data['helplink'] = "https://cutt.ly/mCo9OK0";
			if (defined ('DISABLED_PTS_HELP')){if(DISABLED_PTS_HELP == 0){$data['helpcheck'] = 1;}else{$data['helpcheck'] = 0;}}else{$data['helpcheck'] = 1;}
			$data['helpimage'] = HTTP_CATALOG . '/extension/purpletree_multivendor/admin/view/image/help.png';
			/// End Help code///
			$data['breadcrumbs'] = array();
			
			$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
			);
			
			$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_seller_template_product'),
			'href' => $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . $url, true)
			);
			$data['column_store_name'] = $this->language->get('column_store_name');
			$data['add'] = $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
			$data['delete'] = $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);
			
			$data['products'] = array();
			
			$filter_data = array(
			'filter_name'	  => $filter_name,
			'filter_store'	  => $filter_store,
			'filter_model'	  => $filter_model,
			'filter_status'   => $filter_status,
			'filter_price'   => $filter_price,
			'filter_quantity'   => $filter_quantity,
			'sort'            => $sort,
			'order'           => $order,
			'start'           => ($page - 1) * $this->config->get('config_pagination_admin'),
			'limit'           => $this->config->get('config_pagination_admin')
			);
			
			$this->load->model('tool/image');
			$this->load->model('extension/purpletree_multivendor/multivendor/vendor');
			
			$product_total = $this->model_extension_purpletree_multivendor_multivendor_vendor->geSellerproducttemptotal($filter_data);
			
			$results = $this->model_extension_purpletree_multivendor_multivendor_vendor->geSellerproducttemp($filter_data);
			
			foreach ($results as $result) {
				if (is_file(DIR_IMAGE . $result['image'])) {
					$image = $this->model_tool_image->resize($result['image'], 40, 40);
					} else {
					$image = $this->model_tool_image->resize('no_image.png', 40, 40);
				}
				
				$data['products'][] = array(
				'seller_name' => $result['store_name'],
				'product_name' => $result['product_name'],
				'id' => $result['id'],
				'image'      => $image,
				'name'       => $result['name'],
				'model'       => $result['model'],
				'template_price'      => $this->currency->format($result['price'], $this->config->get('config_currency')),
				'template_quantity'      => $result['quantity'],
				'template_status'      => $result['template_status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled'),
				'stock_status_id'      => $result['stock_status_id'],
				'status'     => $result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled'),
				'editdetail'       => $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate|editTemplate', 'user_token=' . $this->session->data['user_token']. '&product_id=' . $result['product_id'] . '&id=' . $result['id'] . $url, true)
				
				);
			}
			
			$data['user_token'] = $this->session->data['user_token'];
			
			if (isset($this->error['warning'])) {
				$data['error_warning'] = $this->error['warning'];
				} else {
				$data['error_warning'] = '';
			}
			
			if (isset($this->session->data['success'])) {
				$data['success'] = $this->session->data['success'];
				
				unset($this->session->data['success']);
				} else {
				$data['success'] = '';
			}
			
			if (isset($this->request->post['selected'])) {
				$data['selected'] = (array)$this->request->post['selected'];
				} else {
				$data['selected'] = array();
			}
			
			$url = '';
			
			if (isset($this->request->get['filter_store'])) {
				$url .= '&filter_store=' . urlencode(html_entity_decode($this->request->get['filter_store'], ENT_QUOTES, 'UTF-8'));
			}		
			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}
			
			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
			}
			
			if (isset($this->request->get['filter_price'])) {
				$url .= '&filter_price=' . $this->request->get['filter_price'];
			}		
			
			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
			}
			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}
			
			if ($order == 'ASC') {
				$url .= '&order=DESC';
				} else {
				$url .= '&order=ASC';
			}
			
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$data['sort_storename'] = $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . '&sort=pvs.store_name' . $url, true);
			$data['sort_name'] = $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.name' . $url, true);
			$data['sort_model'] = $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . '&sort=p.model' . $url, true);
			$data['sort_price'] = $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . '&sort=pvtps.price' . $url, true);
			$data['sort_status'] = $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . '&sort=p.status' . $url, true);
			$data['sort_quantity'] = $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . '&sort=pvtps.quantity' . $url, true);
			$data['sort_order'] = $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . '&sort=p.sort_order' . $url, true);
			
			$url = '';
			
			if (isset($this->request->get['filter_store'])) {
				$url .= '&filter_store=' . urlencode(html_entity_decode($this->request->get['filter_store'], ENT_QUOTES, 'UTF-8'));
			}		
			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}
			if (isset($this->request->get['filter_price'])) {
				$url .= '&filter_price=' . $this->request->get['filter_price'];
			}
			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
			}
			
			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
			}
			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}
			
			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

$data['pagination'] = $this->load->controller('common/pagination', [
			'total' => $product_total,
			'page'  => $page,
			'limit' => $this->config->get('config_pagination_admin'),
			'url'   => $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true)
		]);
			$data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $this->config->get('config_pagination_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_pagination_admin')) > ($product_total - $this->config->get('config_pagination_admin'))) ? $product_total : ((($page - 1) * $this->config->get('config_pagination_admin')) + $this->config->get('config_pagination_admin')), $product_total, ceil($product_total / $this->config->get('config_pagination_admin')));
			
			$data['filter_store'] = $filter_store;
			$data['filter_price'] = $filter_price;
			$data['filter_quantity'] = $filter_quantity;
			$data['filter_name'] = $filter_name;
			$data['filter_model'] = $filter_model;
			$data['filter_status'] = $filter_status;
			
			$data['sort'] = $sort;
			$data['order'] = $order;
			
			$data['header'] = $this->load->controller('common/header');
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['footer'] = $this->load->controller('common/footer');
			if(version_compare(VERSION, '4.0.2.0', '>=')) {
				$data['listtab'] = false;
			} else {
				$data['listtab'] = true;
			}
			$this->response->setOutput($this->load->view('extension/purpletree_multivendor/multivendor/producttemplate', $data));
		}
		
		protected function getForm() {
			$data['text_form'] = !isset($this->request->get['product_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
			
			if (isset($this->error['warning'])) {
				$data['error_warning'] = $this->error['warning'];
				} else {
				$data['error_warning'] = '';
			}
			
			if (isset($this->error['name'])) {
				$data['error_name'] = $this->error['name'];
				} else {
				$data['error_name'] = array();
			}
			
			if (isset($this->error['meta_title'])) {
				$data['error_meta_title'] = $this->error['meta_title'];
				} else {
				$data['error_meta_title'] = array();
			}
			
			if (isset($this->error['model'])) {
				$data['error_model'] = $this->error['model'];
				} else {
				$data['error_model'] = '';
			}
			
			if (isset($this->error['keyword'])) {
				$data['error_keyword'] = $this->error['keyword'];
				} else {
				$data['error_keyword'] = '';
			}
			
			$url = '';
			
			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
			}
			
			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
			}
			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}
			
			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			///Help code///	
			//$data['helplink'] = "https://www.purpletreesoftware.com/knowledgebase/tag/opencart-multivendor-seller-template-product";
			$data['helplink'] = "https://cutt.ly/mCo9OK0";
			if (defined ('DISABLED_PTS_HELP')){if(DISABLED_PTS_HELP == 0){$data['helpcheck'] = 1;}else{$data['helpcheck'] = 0;}}else{$data['helpcheck'] = 1;}
			$data['helpimage'] = HTTP_CATALOG . '/extension/purpletree_multivendor/admin/view/image/help.png';
			/// End Help code///
			$data['breadcrumbs'] = array();
			
			$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
			);
			
			$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . $url, true)
			);
			
			if (isset($this->request->get['product_id'])) {
				$data['action'] = $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate|edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $this->request->get['product_id'] . $url, true);
			}
			$data['module_purpletree_multivendor_status'] = $this->config->get('module_purpletree_multivendor_status');
			$data['cancel'] = $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . $url, true);
			
			if (isset($this->request->get['product_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
				$product_info = $this->model_catalog_product->getProduct($this->request->get['product_id']);
			}
			
			$data['user_token'] = $this->session->data['user_token'];
			
			$this->load->model('localisation/language');
			
			$data['languages'] = $this->model_localisation_language->getLanguages();
			
			if (isset($this->request->post['product_description'])) {
				$data['product_description'] = $this->request->post['product_description'];
				} elseif (isset($this->request->get['product_id'])) {
				$data['product_description'] = $this->model_catalog_product->getProductDescriptions($this->request->get['product_id']);
				} else {
				$data['product_description'] = array();
			}
			
			if (isset($this->request->post['model'])) {
				$data['model'] = $this->request->post['model'];
				} elseif (!empty($product_info)) {
				$data['model'] = $product_info['model'];
				} else {
				$data['model'] = '';
			}
			
			if (isset($this->request->post['sku'])) {
				$data['sku'] = $this->request->post['sku'];
				} elseif (!empty($product_info)) {
				$data['sku'] = $product_info['sku'];
				} else {
				$data['sku'] = '';
			}
			
			if (isset($this->request->post['upc'])) {
				$data['upc'] = $this->request->post['upc'];
				} elseif (!empty($product_info)) {
				$data['upc'] = $product_info['upc'];
				} else {
				$data['upc'] = '';
			}
			
			if (isset($this->request->post['ean'])) {
				$data['ean'] = $this->request->post['ean'];
				} elseif (!empty($product_info)) {
				$data['ean'] = $product_info['ean'];
				} else {
				$data['ean'] = '';
			}
			
			if (isset($this->request->post['jan'])) {
				$data['jan'] = $this->request->post['jan'];
				} elseif (!empty($product_info)) {
				$data['jan'] = $product_info['jan'];
				} else {
				$data['jan'] = '';
			}
			
			if (isset($this->request->post['isbn'])) {
				$data['isbn'] = $this->request->post['isbn'];
				} elseif (!empty($product_info)) {
				$data['isbn'] = $product_info['isbn'];
				} else {
				$data['isbn'] = '';
			}
			
			if (isset($this->request->post['mpn'])) {
				$data['mpn'] = $this->request->post['mpn'];
				} elseif (!empty($product_info)) {
				$data['mpn'] = $product_info['mpn'];
				} else {
				$data['mpn'] = '';
			}
			
			if (isset($this->request->post['location'])) {
				$data['location'] = $this->request->post['location'];
				} elseif (!empty($product_info)) {
				$data['location'] = $product_info['location'];
				} else {
				$data['location'] = '';
			}
			
			$this->load->model('setting/store');
			
			$data['stores'] = array();
			
			$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $this->language->get('text_default')
			);
			
			$stores = $this->model_setting_store->getStores();
			
			foreach ($stores as $store) {
				$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
				);
			}
			
			if (isset($this->request->post['product_store'])) {
				$data['product_store'] = $this->request->post['product_store'];
				} elseif (isset($this->request->get['product_id'])) {
				$data['product_store'] = $this->model_catalog_product->getProductStores($this->request->get['product_id']);
				} else {
				$data['product_store'] = array(0);
			}
			
			if (isset($this->request->post['shipping'])) {
				$data['shipping'] = $this->request->post['shipping'];
				} elseif (!empty($product_info)) {
				$data['shipping'] = $product_info['shipping'];
				} else {
				$data['shipping'] = 1;
			}
			
			$this->load->model('catalog/recurring');
			
			$data['recurrings'] = $this->model_catalog_recurring->getRecurrings();
			
			if (isset($this->request->post['product_recurrings'])) {
				$data['product_recurrings'] = $this->request->post['product_recurrings'];
				} elseif (!empty($product_info)) {
				$data['product_recurrings'] = $this->model_catalog_product->getRecurrings($product_info['product_id']);
				} else {
				$data['product_recurrings'] = array();
			}
			
			$this->load->model('localisation/tax_class');
			
			$data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();
			
			if (isset($this->request->post['tax_class_id'])) {
				$data['tax_class_id'] = $this->request->post['tax_class_id'];
				} elseif (!empty($product_info)) {
				$data['tax_class_id'] = $product_info['tax_class_id'];
				} else {
				$data['tax_class_id'] = 0;
			}
			
			if (isset($this->request->post['date_available'])) {
				$data['date_available'] = $this->request->post['date_available'];
				} elseif (!empty($product_info)) {
				$data['date_available'] = ($product_info['date_available'] != '0000-00-00') ? $product_info['date_available'] : '';
				} else {
				$data['date_available'] = date('Y-m-d');
			}
			
			if (isset($this->request->post['minimum'])) {
				$data['minimum'] = $this->request->post['minimum'];
				} elseif (!empty($product_info)) {
				$data['minimum'] = $product_info['minimum'];
				} else {
				$data['minimum'] = 1;
			}
			
			if (isset($this->request->post['sort_order'])) {
				$data['sort_order'] = $this->request->post['sort_order'];
				} elseif (!empty($product_info)) {
				$data['sort_order'] = $product_info['sort_order'];
				} else {
				$data['sort_order'] = 1;
			}
			
			$this->load->model('localisation/stock_status');
			
			$data['stock_statuses'] = $this->model_localisation_stock_status->getStockStatuses();
			if (isset($this->request->post['status'])) {
				$data['status'] = $this->request->post['status'];
				} elseif (!empty($product_info)) {
				$data['status'] = $product_info['status'];
				} else {
				$data['status'] = true;
			}
			
			if (isset($this->request->post['weight'])) {
				$data['weight'] = $this->request->post['weight'];
				} elseif (!empty($product_info)) {
				$data['weight'] = $product_info['weight'];
				} else {
				$data['weight'] = '';
			}
			
			$this->load->model('localisation/weight_class');
			
			$data['weight_classes'] = $this->model_localisation_weight_class->getWeightClasses();
			
			if (isset($this->request->post['weight_class_id'])) {
				$data['weight_class_id'] = $this->request->post['weight_class_id'];
				} elseif (!empty($product_info)) {
				$data['weight_class_id'] = $product_info['weight_class_id'];
				} else {
				$data['weight_class_id'] = $this->config->get('config_weight_class_id');
			}
			
			if (isset($this->request->post['length'])) {
				$data['length'] = $this->request->post['length'];
				} elseif (!empty($product_info)) {
				$data['length'] = $product_info['length'];
				} else {
				$data['length'] = '';
			}
			
			if (isset($this->request->post['width'])) {
				$data['width'] = $this->request->post['width'];
				} elseif (!empty($product_info)) {
				$data['width'] = $product_info['width'];
				} else {
				$data['width'] = '';
			}
			
			if (isset($this->request->post['height'])) {
				$data['height'] = $this->request->post['height'];
				} elseif (!empty($product_info)) {
				$data['height'] = $product_info['height'];
				} else {
				$data['height'] = '';
			}
			
			$this->load->model('localisation/length_class');
			
			$data['length_classes'] = $this->model_localisation_length_class->getLengthClasses();
			
			if (isset($this->request->post['length_class_id'])) {
				$data['length_class_id'] = $this->request->post['length_class_id'];
				} elseif (!empty($product_info)) {
				$data['length_class_id'] = $product_info['length_class_id'];
				} else {
				$data['length_class_id'] = $this->config->get('config_length_class_id');
			}
			
			$this->load->model('catalog/manufacturer');
			
			if (isset($this->request->post['manufacturer_id'])) {
				$data['manufacturer_id'] = $this->request->post['manufacturer_id'];
				} elseif (!empty($product_info)) {
				$data['manufacturer_id'] = $product_info['manufacturer_id'];
				} else {
				$data['manufacturer_id'] = 0;
			}
			
			if (isset($this->request->post['manufacturer'])) {
				$data['manufacturer'] = $this->request->post['manufacturer'];
				} elseif (!empty($product_info)) {
				$manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($product_info['manufacturer_id']);
				
				if ($manufacturer_info) {
					$data['manufacturer'] = $manufacturer_info['name'];
					} else {
					$data['manufacturer'] = '';
				}
				} else {
				$data['manufacturer'] = '';
			}
			
			// Categories
			$this->load->model('catalog/category');
			
			if (isset($this->request->post['product_category'])) {
				$categories = $this->request->post['product_category'];
				} elseif (isset($this->request->get['product_id'])) {
				$categories = $this->model_catalog_product->getProductCategories($this->request->get['product_id']);
				} else {
				$categories = array();
			}
			
			$data['product_categories'] = array();
			
			foreach ($categories as $category_id) {
				$category_info = $this->model_catalog_category->getCategory($category_id);
				
				if ($category_info) {
					$data['product_categories'][] = array(
					'category_id' => $category_info['category_id'],
					'name'        => ($category_info['path']) ? $category_info['path'] . ' &gt; ' . $category_info['name'] : $category_info['name']
					);
				}
			}
			
			// Filters
			$this->load->model('catalog/filter');
			
			if (isset($this->request->post['product_filter'])) {
				$filters = $this->request->post['product_filter'];
				} elseif (isset($this->request->get['product_id'])) {
				$filters = $this->model_catalog_product->getProductFilters($this->request->get['product_id']);
				} else {
				$filters = array();
			}
			
			$data['product_filters'] = array();
			
			foreach ($filters as $filter_id) {
				$filter_info = $this->model_catalog_filter->getFilter($filter_id);
				
				if ($filter_info) {
					$data['product_filters'][] = array(
					'filter_id' => $filter_info['filter_id'],
					'name'      => $filter_info['group'] . ' &gt; ' . $filter_info['name']
					);
				}
			}
			
			// Attributes
			$this->load->model('catalog/attribute');
			
			if (isset($this->request->post['product_attribute'])) {
				$product_attributes = $this->request->post['product_attribute'];
				} elseif (isset($this->request->get['product_id'])) {
				$product_attributes = $this->model_catalog_product->getProductAttributes($this->request->get['product_id']);
				} else {
				$product_attributes = array();
			}
			
			$data['product_attributes'] = array();
			
			foreach ($product_attributes as $product_attribute) {
				$attribute_info = $this->model_catalog_attribute->getAttribute($product_attribute['attribute_id']);
				
				if ($attribute_info) {
					$data['product_attributes'][] = array(
					'attribute_id'                  => $product_attribute['attribute_id'],
					'name'                          => $attribute_info['name'],
					'product_attribute_description' => $product_attribute['product_attribute_description']
					);
				}
			}
			
			// Options
			$this->load->model('catalog/option');
			
			if (isset($this->request->post['product_option'])) {
				$product_options = $this->request->post['product_option'];
				} elseif (isset($this->request->get['product_id'])) {
				$product_options = $this->model_catalog_product->getProductOptions($this->request->get['product_id']);
				} else {
				$product_options = array();
			}
			
			$data['product_options'] = array();
			
			foreach ($product_options as $product_option) {
				$product_option_value_data = array();
				
				if (isset($product_option['product_option_value'])) {
					foreach ($product_option['product_option_value'] as $product_option_value) {
						$product_option_value_data[] = array(
						'product_option_value_id' => $product_option_value['product_option_value_id'],
						'option_value_id'         => $product_option_value['option_value_id'],
						'points'                  => $product_option_value['points'],
						'points_prefix'           => $product_option_value['points_prefix'],
						'weight'                  => $product_option_value['weight'],
						'weight_prefix'           => $product_option_value['weight_prefix']
						);
					}
				}
				
				$data['product_options'][] = array(
				'product_option_id'    => $product_option['product_option_id'],
				'product_option_value' => $product_option_value_data,
				'option_id'            => $product_option['option_id'],
				'name'                 => $product_option['name'],
				'type'                 => $product_option['type'],
				'value'                => isset($product_option['value']) ? $product_option['value'] : '',
				'required'             => $product_option['required']
				);
			}
			
			$data['option_values'] = array();
			
			foreach ($data['product_options'] as $product_option) {
				if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
					if (!isset($data['option_values'][$product_option['option_id']])) {
						$data['option_values'][$product_option['option_id']] = $this->model_catalog_option->getValues($product_option['option_id']);
					}
				}
			}
			
			$this->load->model('customer/customer_group');
			
			$data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();
			
			// Image
			if (isset($this->request->post['image'])) {
				$data['image'] = $this->request->post['image'];
				} elseif (!empty($product_info)) {
				$data['image'] = $product_info['image'];
				} else {
				$data['image'] = '';
			}
			
			$this->load->model('tool/image');
			
			if (isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image'])) {
				$data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 100, 100);
				} elseif (!empty($product_info) && is_file(DIR_IMAGE . $product_info['image'])) {
				$data['thumb'] = $this->model_tool_image->resize($product_info['image'], 100, 100);
				} else {
				$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
			}
			
			$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
			
			// Images
			if (isset($this->request->post['product_image'])) {
				$product_images = $this->request->post['product_image'];
				} elseif (isset($this->request->get['product_id'])) {
				$product_images = $this->model_catalog_product->getProductImages($this->request->get['product_id']);
				} else {
				$product_images = array();
			}
			
			$data['product_images'] = array();
			
			foreach ($product_images as $product_image) {
				if (is_file(DIR_IMAGE . $product_image['image'])) {
					$image = $product_image['image'];
					$thumb = $product_image['image'];
					} else {
					$image = '';
					$thumb = 'no_image.png';
				}
				
				$data['product_images'][] = array(
				'image'      => $image,
				'thumb'      => $this->model_tool_image->resize($thumb, 100, 100),
				'sort_order' => $product_image['sort_order']
				);
			}
			
			// Downloads
			$this->load->model('catalog/download');
			
			if (isset($this->request->post['product_download'])) {
				$product_downloads = $this->request->post['product_download'];
				} elseif (isset($this->request->get['product_id'])) {
				$product_downloads = $this->model_catalog_product->getProductDownloads($this->request->get['product_id']);
				} else {
				$product_downloads = array();
			}
			
			$data['product_downloads'] = array();
			
			foreach ($product_downloads as $download_id) {
				$download_info = $this->model_catalog_download->getDownload($download_id);
				
				if ($download_info) {
					$data['product_downloads'][] = array(
					'download_id' => $download_info['download_id'],
					'name'        => $download_info['name']
					);
				}
			}
			
			if (isset($this->request->post['product_related'])) {
				$products = $this->request->post['product_related'];
				} elseif (isset($this->request->get['product_id'])) {
				$products = $this->model_catalog_product->getProductRelated($this->request->get['product_id']);
				} else {
				$products = array();
			}
			
			$data['product_relateds'] = array();
			
			foreach ($products as $product_id) {
				$related_info = $this->model_catalog_product->getProduct($product_id);
				
				if ($related_info) {
					$data['product_relateds'][] = array(
					'product_id' => $related_info['product_id'],
					'name'       => $related_info['name']
					);
				}
			}
			
			if (isset($this->request->post['points'])) {
				$data['points'] = $this->request->post['points'];
				} elseif (!empty($product_info)) {
				$data['points'] = $product_info['points'];
				} else {
				$data['points'] = '';
			}
			
			if (isset($this->request->post['product_reward'])) {
				$data['product_reward'] = $this->request->post['product_reward'];
				} elseif (isset($this->request->get['product_id'])) {
				$data['product_reward'] = $this->model_catalog_product->getProductRewards($this->request->get['product_id']);
				} else {
				$data['product_reward'] = array();
			}
			
			if (isset($this->request->post['product_seo_url'])) {
				$data['product_seo_url'] = $this->request->post['product_seo_url'];
				} elseif (isset($this->request->get['product_id'])) {
				$data['product_seo_url'] = $this->model_catalog_product->getProductSeoUrls($this->request->get['product_id']);
				} else {
				$data['product_seo_url'] = array();
			}
			
			if (isset($this->request->post['product_layout'])) {
				$data['product_layout'] = $this->request->post['product_layout'];
				} elseif (isset($this->request->get['product_id'])) {
				$data['product_layout'] = $this->model_catalog_product->getProductLayouts($this->request->get['product_id']);
				} else {
				$data['product_layout'] = array();
			}
			
			$this->load->model('design/layout');
			
			$data['layouts'] = $this->model_design_layout->getLayouts();
			
			$data['header'] = $this->load->controller('common/header');
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['footer'] = $this->load->controller('common/footer');
			if(version_compare(VERSION, '4.0.2.0', '>=')) {
				$data['listtab'] = false;
			} else {
				$data['listtab'] = true;
			}
			$this->response->setOutput($this->load->view('extension/purpletree_multivendor/multivendor/admintemplate_form', $data));
		}
		public function productForm() {
			$this->document->addStyle('../extension/purpletree_multivendor/admin/view/javascript/purpletreecss/commonstylesheet.css');
			$this->load->language('extension/purpletree_multivendor/multivendor/admintemplate');
			
			$this->document->setTitle($this->language->get('heading_title'));
			
			$this->load->model('extension/purpletree_multivendor/multivendor/vendor');
			$this->load->model('localisation/stock_status');
			
			if (isset($this->request->get['id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
				$product_info = $this->model_extension_purpletree_multivendor_multivendor_vendor->getTemplateDetail($this->request->get['id']);
				
// template options
		
// Options
		$this->load->model('catalog/option');

		if (isset($this->request->get['id'])) {
			//$product_options = $this->request->get['id'];
			$product_options = $this->model_extension_purpletree_multivendor_multivendor_vendor->getProductOptions($this->request->get['id']);
	
		} elseif (isset($this->request->get['id'])) {
			$product_options = $this->model_extension_purpletree_multivendor_multivendor_vendor->getProductOptions($this->request->get['id']);
		} else {
			$product_options = array();
		}
		$product_id='';
		if(isset($this->request->get['product_id'])){
			$product_id=$this->request->get['product_id'];
		}
// echo "<pre>";
// print_r($product_options);
// die;
		$data['product_options'] = array();

		foreach ($product_options as $product_option) {
			$product_option_value_data = array();

			if (isset($product_option['product_option_value'])) {
				foreach ($product_option['product_option_value'] as $product_option_value) {
					$product_option_value_data[] = array(
						'product_option_value_id' => $product_option_value['product_option_value_id'],
						'option_value_id'         => $product_option_value['option_value_id'],
						'quantity'                => $product_option_value['quantity'],
						'subtract'                => $product_option_value['subtract'],
						'price'                   => $product_option_value['price'],
						'price_prefix'            => $product_option_value['price_prefix']
					);

				}
			}

			$data['product_options'][] = array(
				'product_option_id'    => $product_option['product_option_id'],
				'product_option_value' => $product_option_value_data,
				'option_id'            => $product_option['option_id'],
				'name'                 => $product_option['name'],
				'type'                 => $product_option['type'],
				'value'                => isset($product_option['value']) ? $product_option['value'] : ''
			);
		}
		$data['option_values'] = array();
			
			foreach ($data['product_options'] as $product_option) {
			if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
			if (!isset($data['option_values'][$product_option['option_id']])) {
			$data['option_values'][$product_option['option_id']] = $this->model_extension_purpletree_multivendor_multivendor_vendor->getOptionValuesByProductOptId($product_option['option_id'],$product_id);
			}
			}
			}

			}
			$url ='';
			///Help code///	
			//$data['helplink'] = "https://www.purpletreesoftware.com/knowledgebase/tag/opencart-multivendor-seller-template-product";
			$data['helplink'] = "https://cutt.ly/mCo9OK0";
			if (defined ('DISABLED_PTS_HELP')){if(DISABLED_PTS_HELP == 0){$data['helpcheck'] = 1;}else{$data['helpcheck'] = 0;}}else{$data['helpcheck'] = 1;}
			$data['helpimage'] = HTTP_CATALOG . '/extension/purpletree_multivendor/admin/view/image/help.png';
			/// End Help code///
			$data['breadcrumbs'] = array();
			
			$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
			);
			
			$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_detailform'),
			'href' => $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . $url, true)
			);
			if (isset($this->error['warning'])) {
				$data['error_warning'] = $this->error['warning'];
				} else {
				$data['error_warning'] = '';
			}
			
			if (isset($this->error['price'])) {
				$data['price_error'] = $this->error['price'];
				} else {
				$data['price_error'] = '';
			}
			if (isset($this->error['duplicate_product'])) {
				$data['error_warning'] = $this->error['duplicate_product'];
				} else {
				$data['error_warning'] = '';
			}		
			if (isset($this->error['store_name'])) {
				$data['store_name_error'] = $this->error['store_name'];
				} else {
				$data['store_name_error'] = '';
			}

			if (isset($this->error['quantity'])) {
				$data['quantity_error'] = $this->error['quantity'];
				} else {
				$data['quantity_error'] = '';
			}		
			
			if (isset($this->session->data['success'])) {
				$data['success'] = $this->session->data['success'];
				unset($this->session->data['success']);
				} else {
				$data['success'] = '';
			}
			if (isset($this->request->post['store_name'])) {
				$data['store_name'] = $this->request->post['store_name'];
				} elseif (!empty($product_info['store_name'])) {
				$data['store_name'] = $product_info['store_name'];
				} else {
				$data['store_name'] = '';
			}		
			if (isset($this->request->post['quantity'])) {
				$data['quantity'] = $this->request->post['quantity'];
				} elseif (!empty($product_info['quantity'])) {
				$data['quantity'] = $product_info['quantity'];
				} else {
				$data['quantity'] = '';
			}	
			if (isset($this->request->post['status'])) {
				$data['status'] = $this->request->post['status'];
				} elseif (!empty($product_info)) {
				$data['status'] = $product_info['status'];
				} else {
				$data['status'] = true;
			}		
			if (isset($this->request->post['price'])) {
				$data['price'] = $this->request->post['price'];
				} elseif (!empty($product_info['price'])) {
				$data['price'] = $product_info['price'];
				} else {
				$data['price'] = '';
			}		
			if (isset($this->request->post['stock_status'])) {
				$data['stock_status'] = $this->request->post['stock_status'];
				} elseif (!empty($product_info['stock_status'])) {
				$data['stock_status'] = $product_info['stock_status'];
				} else {
				$data['stock_status'] = '';
			}		
			if (isset($this->request->post['stock_status_id'])) {
				$data['stock_status_id'] = $this->request->post['stock_status_id'];
				} elseif (!empty($product_info['stock_status_id'])) {
				$data['stock_status_id'] = $product_info['stock_status_id'];
				} else {
				$data['stock_status_id'] = '';
			}			
			if (isset($this->request->post['vendor'])) {
				$data['vendor'] = $this->request->post['vendor'];
				} elseif (!empty($product_info['seller_id'])) {
				$data['vendor'] = (int)$product_info['seller_id'];
				} else {
				$data['vendor'] = '';
			}	
			if (isset($this->request->post['subtract'])) {
				$data['subtract'] = $this->request->post['subtract'];
				} elseif (!empty($product_info['subtract'])) {
				$data['subtract'] = $product_info['subtract'];
				} else {
				$data['subtract'] = '';
			}	
			if (isset($this->request->post['status'])) {
				$data['status'] = $this->request->post['status'];
				} elseif (!empty($product_info['status'])) {
				$data['status'] = $product_info['status'];
				} else {	
				$data['status'] = '';
			}		
			$data['product_id'] = $this->request->get['product_id'];
			if (isset($this->request->get['id'])) {
				$data['action'] = $this->url->link('extension/purpletree_multivendor/multivendor/producttemplate|editTemplate', 'user_token=' . $this->session->data['user_token'] . '&product_id='.$data['product_id'].'&id=' . $this->request->get['id'] . $url, true);
			}
			$data['stock_statuses'] = $this->model_localisation_stock_status->getStockStatuses();
			
			if(isset($this->request->get['id'])){	
				$data['template_id'] = $this->model_extension_purpletree_multivendor_multivendor_vendor->getTemplateId1($this->request->get['id']);
			}
			if(isset($this->request->get['id'])){	
				$data['id'] = $this->request->get['id'];
			} 
			$data['user_token'] = $this->session->data['user_token'];
			$data['vendors'] = $this->model_extension_purpletree_multivendor_multivendor_vendor->getVendors();
			$data['header'] = $this->load->controller('common/header');
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['footer'] = $this->load->controller('common/footer');
			if(version_compare(VERSION, '4.0.2.0', '>=')) {
				$data['listtab'] = false;
			} else {
				$data['listtab'] = true;
			}
			if(version_compare(VERSION, '4.0.2.0', '>=')) {
				$data['listtab'] = false;
			} else {
				$data['listtab'] = true;
			}
			$this->response->setOutput($this->load->view('extension/purpletree_multivendor/multivendor/sellertemplatedetail_form',$data));
		}
		public function editTemplate() {
			$this->load->language('extension/purpletree_multivendor/multivendor/admintemplate');
			
			$this->document->setTitle($this->language->get('heading_title'));
			
			$this->load->model('extension/purpletree_multivendor/multivendor/vendor');
			
			if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateFormTemp()) {
				$this->model_extension_purpletree_multivendor_multivendor_vendor->editsellertempDetail($this->request->get['id'], $this->request->post);
				$minprice = $this->model_extension_purpletree_multivendor_multivendor_vendor->getMinPrice($this->request->post['product_id']);

			$tproduct_id= $this->model_extension_purpletree_multivendor_multivendor_vendor->getProductid($this->request->post['template_id']);
			  if($this->request->post['status'] == 1){
			    $this->db->query("UPDATE " . DB_PREFIX . "product SET status = '" . (int)$this->request->post['status'] . "' WHERE product_id = '" . (int)$tproduct_id . "'");
				}else{
				  $temp_status = $this->model_extension_purpletree_multivendor_multivendor_vendor->checkTempstatus($tproduct_id);		
			     if($temp_status == 1){
			      $status1 = 1;
				  $this->db->query("UPDATE " . DB_PREFIX . "product SET status = '" . (int)$status1 . "' WHERE product_id = '" . (int)$tproduct_id . "'");
				  }else{
				    $status1 = 0;
				  $this->db->query("UPDATE " . DB_PREFIX . "product SET status = '" . (int)$status1 . "' WHERE product_id = '" . (int)$tproduct_id . "'");
				  }
				}
				
				$this->db->query("UPDATE " . DB_PREFIX . "product SET price = '" . (float)$minprice['min_price'] . "', stock_status_id = '" . (int)$minprice['stock_status_id'] . "', subtract = '" . (int)$minprice['subtract'] . "', quantity = '" . (int)$minprice['quantity'] . "' WHERE product_id = '" . (int)$minprice['product_id'] . "'");
				
				$this->session->data['success'] = $this->language->get('text_success');
				
				$url = '';
				
				if (isset($this->request->get['filter_name'])) {
					$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
				}
				
				if (isset($this->request->get['filter_model'])) {
					$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
				}
				
				if (isset($this->request->get['filter_status'])) {
					$url .= '&filter_status=' . $this->request->get['filter_status'];
				}
				
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}
				
				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}
				
				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				
				$this->response->redirect($this->url->link('extension/purpletree_multivendor/multivendor/producttemplate', 'user_token=' . $this->session->data['user_token'] . $url, true));
			}
			
			$this->productForm();
		}
		protected function validateFormTemp() {
			if (!$this->user->hasPermission('modify', 'extension/purpletree_multivendor/multivendor/admintemplate')) {
				$this->error['warning'] = $this->language->get('error_permission');
			}
			if (($this->request->post['seller_id_filter']) =='') {
				$this->error['store_name'] = $this->language->get('Store name is required');
			}
			
			if (($this->request->post['quantity']) < 1) {
				$this->error['quantity'] = $this->language->get('Quantity is required');
			}	
			if (($this->request->post['price']) < 1) {
				$this->error['price'] = $this->language->get('Price is required');
			}
			
			
			$template_num_rows = $this->model_extension_purpletree_multivendor_multivendor_vendor->getEditTemplateData($this->request->post['template_id'],$this->request->post['seller_id_filter'],$this->request->post['id']); 
			if ($template_num_rows > 0) {
				$this->error['duplicate_product'] = $this->language->get('This template product is already assigned for this store.');
			}

			
			if ($this->error && !isset($this->error['warning'])) {
				$this->error['warning'] = $this->language->get('error_warning');
			}		
			
			return !$this->error;
		}
		
		protected function validateForm() {
			if (!$this->user->hasPermission('modify', 'extension/purpletree_multivendor/multivendor/admintemplate')) {
				$this->error['warning'] = $this->language->get('error_permission');
			}
			
			foreach ($this->request->post['product_description'] as $language_id => $value) {
				if ((strlen($value['name']) < 1) || (strlen($value['name']) > 255)) {
					$this->error['name'][$language_id] = $this->language->get('error_name');
				}
				
				if ((strlen($value['meta_title']) < 1) || (strlen($value['meta_title']) > 255)) {
					$this->error['meta_title'][$language_id] = $this->language->get('error_meta_title');
				}
			}
			
			if ((strlen($this->request->post['model']) < 1) || (strlen($this->request->post['model']) > 64)) {
				$this->error['model'] = $this->language->get('error_model');
			}
			
			if ($this->request->post['product_seo_url']) {
				$this->load->model('design/seo_url');
				
				foreach ($this->request->post['product_seo_url'] as $store_id => $language) {
					foreach ($language as $language_id => $keyword) {
						if (!empty($keyword)) {
							if (count(array_keys($language, $keyword)) > 1) {
								$this->error['keyword'][$store_id][$language_id] = $this->language->get('error_unique');
							}						
							
							$seo_urls = $this->model_design_seo_url->getSeoUrlsByKeyword($keyword);
							
							foreach ($seo_urls as $seo_url) {
								if (($seo_url['store_id'] == $store_id) && (!isset($this->request->get['product_id']) || (($seo_url['query'] != 'product_id=' . $this->request->get['product_id'])))) {
									$this->error['keyword'][$store_id][$language_id] = $this->language->get('error_keyword');
									
									break;
								}
							}
						}
					}
				}
			}
			
			if ($this->error && !isset($this->error['warning'])) {
				$this->error['warning'] = $this->language->get('error_warning');
			}
			
			return !$this->error;
		}
		
		protected function validateDelete() {
			if (!$this->user->hasPermission('modify', 'extension/purpletree_multivendor/multivendor/producttemplate')) {
				$this->error['warning'] = $this->language->get('error_permission');
			}
			
			return !$this->error;
		}
		public function autosellerstore() {
			$json = array();
			
			if (isset($this->request->get['store_name'])) {
				$store_name = $this->request->get['store_name'];
				} else {
				$store_name = '';
			}
			$this->load->model('extension/purpletree_multivendor/multivendor/stores');		
			$results = $this->model_extension_purpletree_multivendor_multivendor_stores->getSellerstore($store_name);
			if(!empty($results)){
				foreach ($results as $result) {
					$json[] = array(
					'vendor_id'       => $result['seller_id'],
					'name'              => strip_tags(html_entity_decode($result['store_name'], ENT_QUOTES, 'UTF-8'))	
					);
				}
			}			
			
			$this->response->addHeader('Content-Type: application/json');
			$this->response->setOutput(json_encode($json));
		}
		
		public function autocomplete() {
			$json = array();
			
			if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_model']) || isset($this->request->get['filter_store'])) {
				$this->load->model('catalog/product');
				$this->load->model('extension/purpletree_multivendor/multivendor/vendor');
				
				if (isset($this->request->get['filter_store'])) {
					$filter_store = $this->request->get['filter_store'];
					} else {
					$filter_store = '';
				}
				if (isset($this->request->get['filter_name'])) {
					$filter_name = $this->request->get['filter_name'];
					} else {
					$filter_name = '';
				}
				
				if (isset($this->request->get['filter_model'])) {
					$filter_model = $this->request->get['filter_model'];
					} else {
					$filter_model = '';
				}
				
				if (isset($this->request->get['filter_status'])) {
					$filter_status = $this->request->get['filter_status'];
					} else {
					$filter_status = '';
				}
				if (isset($this->request->get['filter_price'])) {
					$filter_price = $this->request->get['filter_price'];
					} else {
					$filter_price = '';
				}			
				if (isset($this->request->get['filter_quantity'])) {
					$filter_quantity = $this->request->get['filter_quantity'];
					} else {
					$filter_quantity = '';
				}
				
				if (isset($this->request->get['limit'])) {
					$limit = $this->request->get['limit'];
					} else {
					$limit = 5;
				}
				
				$filter_data = array(
				'filter_store'  => $filter_store,
				'filter_name'  => $filter_name,
				'filter_model' => $filter_model,
				'filter_status' => $filter_status,
				'filter_price' => $filter_price,
				'filter_quantity' => $filter_quantity,
				'start'        => 0,
				'limit'        => $limit
				);
				
				$results = $this->model_extension_purpletree_multivendor_multivendor_vendor->geSellerproducttemp($filter_data);
				
				foreach ($results as $result) {
					$json[] = array(
					'product_id' => $result['product_id'],
					'store_name'      => $result['store_name'],
					'name'       => strip_tags(html_entity_decode($result['product_name'], ENT_QUOTES, 'UTF-8')),
					'model'      => $result['model'],
					'status'      => $result['template_status'],
					'price'      => $result['price']
					);
					//	echo"<pre>"; print_r($result); die;
				}
			}
			$this->response->addHeader('Content-Type: application/json');
			$this->response->setOutput(json_encode($json));
		}
		
	public function getTemplateProductOptions() {
		$json = array();
		if (isset($this->request->get['filter_name']) && isset($this->request->get['product_id'])) {
			$this->load->language('catalog/option');

			$this->load->model('catalog/option');

			$this->load->model('tool/image');
			$this->load->model('extension/purpletree_multivendor/multivendor/vendor');
			$product_id=$this->request->get['product_id'];
			$filter_data = array(
				'filter_name' => $this->request->get['filter_name'],
				'start'       => 0,
				'limit'       => 5
			);

			$options = $this->model_catalog_option->getOptions($filter_data);

			foreach ($options as $option) {
				$results = $this->model_extension_purpletree_multivendor_multivendor_vendor->getTemplateProductStatus($product_id,$option['option_id']);
				if(!empty($results) && ($option['type'] == 'select' || $option['type'] == 'radio')){
				$option_value_data = array();

				if ($option['type'] == 'select' || $option['type'] == 'radio') {
					$option_values = $this->model_catalog_option->getValues($option['option_id']);
				foreach ($option_values as $option_value) {
					$data=array(
					'product_option_id'=>$results['product_option_id'],
					'product_id'=>$product_id,
					'option_id'=>$option['option_id'],
					'option_value_id'=>$option_value['option_value_id'],
					);
				$checkOptions = $this->model_extension_purpletree_multivendor_multivendor_vendor->getTemplateProductOption($data);
				if($checkOptions){
						if (is_file(DIR_IMAGE . $option_value['image'])) {
							$image = $this->model_tool_image->resize($option_value['image'], 50, 50);
						} else {
							$image = $this->model_tool_image->resize('no_image.png', 50, 50);
						}

						$option_value_data[] = array(
							'option_value_id' => $option_value['option_value_id'],
							'name'            => strip_tags(html_entity_decode($option_value['name'], ENT_QUOTES, 'UTF-8')),
							'image'           => $image
						);
					}
				}

					$sort_order = array();

					foreach ($option_value_data as $key => $value) {
						$sort_order[$key] = $value['name'];
					}

					array_multisort($sort_order, SORT_ASC, $option_value_data);
				}

				$type = '';

				if ($option['type'] == 'select' || $option['type'] == 'radio') {
					$type = $this->language->get('text_choose');
				}

				$json[] = array(
					'option_id'    => $option['option_id'],
					'name'         => strip_tags(html_entity_decode($option['name'], ENT_QUOTES, 'UTF-8')),
					'category'     => $type,
					'type'         => $option['type'],
					'option_value' => $option_value_data
				);
			}
			}
		}

		$sort_order = array();

		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['name'];
		}

		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}
?>