<?php

namespace Opencart\Catalog\Controller\Extension\PurpletreeMultivendor\Multivendor\Api;

class Sellerlogin extends \Opencart\System\Engine\Controller
{
	private $error = array();
	public function index()
	{
		$json['message'] = array();
		$json['status'] = array();
		$this->load->language('extension/purpletree_multivendor/multivendor/api');
		if ($this->config->get('module_purpletree_multivendor_status')) {
			if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
				if (!empty($_POST)) {
					$requestData = $_POST;
					$post = $requestData;
				} else {
					$requestData = file_get_contents("php://input");
					$post = json_decode($requestData, true);
				}

				$seller_email = $post['email'];
				$seller_password = $post['password'];
				$this->load->model('extension/purpletree_multivendor/multivendor/vendor');
				$seller_id = $this->model_extension_purpletree_multivendor_multivendor_vendor->getSellerId($seller_email);

				$isSeller = $this->model_extension_purpletree_multivendor_multivendor_vendor->is_seller($seller_id);

				if ($isSeller) {

					$this->load->model('account/customer');
					$this->model_account_customer->deleteLoginAttempts($seller_email);
					$seller_loggedin = $this->customer->login($seller_email, $seller_password);

					unset($this->session->data['guest']);
					if ($seller_loggedin) {

						$json['message'] = $this->language->get('seller_login_succ');
						$json['status'] = true;
					} else {
						$json['status'] = false;
						$json['message'] = $this->language->get('seller_login_fail');
					}
				} else {
					$json['status'] = false;
					$json['message'] = $this->language->get('seller_login_fail'); // Please enter valid seller credential.
				}
			}
		} else {
			$json['message'] = $this->language->get('multivendor_enable');
			$json['status'] = false;
		}
		$this->response->addHeader('Content-Type: application/json');
		return $this->response->setOutput(json_encode($json));
	}
}
