<?php
namespace Opencart\Catalog\Controller\Extension\PurpletreeMultivendor\Multivendor\Api;
require_once(DIR_EXTENSION.'purpletree_multivendor/system/library/MyCustomLibrary.php');
class Shipping  extends \Opencart\System\Engine\Controller{
		
		private $error = array();
		
		private $json = array();
		
		public function index() {
			$this->registry->set('pts', new  \PurpletreeMultivendor\System\Library\MyCustomLibrary($this->registry));
			$this->checkPlugin();
			$this->load->language('extension/purpletree_multivendor/multivendor/api');
			if (!$this->pts->isMobileApiCall()) { 
				$json['status'] = 'error';
				$json['message'] = $this->language->get('error_permission');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			}
			if (!$this->customer->isLogged()) {
				$json['status'] = 'error';
				$json['message'] = $this->language->get('seller_not_logged');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			}
			
			$this->load->model('extension/purpletree_multivendor/multivendor/dashboard');
			$store_detail = $this->model_extension_purpletree_multivendor_multivendor_dashboard->isSeller($this->customer->getId());
			if(!isset($store_detail['store_status'])){
				$json['status'] = 'error';
				$json['message'] = $this->language->get('seller_not_approved');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json)); 
			}
			if(!$this->pts->validateSeller()) {		
				$json['status'] = 'error';
				$json['message'] = $this->language->get('error_license');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			} 
			
			$this->load->language('extension/purpletree_multivendor/multivendor/shipping');
			$this->load->model('extension/purpletree_multivendor/multivendor/shipping');
			$json = $this->getList();
			$this->response->addHeader('Content-Type: application/json');
			return $this->response->setOutput(json_encode($json)); 
			
		}
		
		public function getcountries() {
			$this->registry->set('pts', new  \PurpletreeMultivendor\System\Library\MyCustomLibrary($this->registry));
			$this->checkPlugin();
			$this->load->language('extension/purpletree_multivendor/multivendor/api');
			if (!$this->pts->isMobileApiCall()) { 
				$json['status'] = 'error';
				$json['message'] = $this->language->get('error_permission');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			}
			if (!$this->customer->isLogged()) {
				$json['status'] = 'error';
				$json['message'] = $this->language->get('seller_not_logged');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			}
			
			$this->load->model('extension/purpletree_multivendor/multivendor/dashboard');
			$store_detail = $this->model_extension_purpletree_multivendor_multivendor_dashboard->isSeller($this->customer->getId());
			if(!isset($store_detail['store_status'])){
				$json['status'] = 'error';
				$json['message'] = $this->language->get('seller_not_approved');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json)); 
			}
			if(!$this->pts->validateSeller()) {		
				$json['status'] = 'error';
				$json['message'] = $this->language->get('error_license');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			} 
			$this->load->model('localisation/country');
			$json['data']['countries'] = $this->model_localisation_country->getCountries();
			$json['status'] = 'success';
			$this->response->addHeader('Content-Type: application/json');
			return $this->response->setOutput(json_encode($json));
		}
		
		public function add() {
			$this->registry->set('pts', new  \PurpletreeMultivendor\System\Library\MyCustomLibrary($this->registry));
			$this->checkPlugin();
			$this->load->language('extension/purpletree_multivendor/multivendor/api');
			if (!$this->pts->isMobileApiCall()) { 
				$json['status'] = 'error';
				$json['message'] = $this->language->get('error_permission');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			}
			if (!$this->customer->isLogged()) {
				$json['status'] = 'error';
				$json['message'] = $this->language->get('seller_not_logged');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			}
			
			$this->load->model('extension/purpletree_multivendor/multivendor/dashboard');
			$store_detail = $this->model_extension_purpletree_multivendor_multivendor_dashboard->isSeller($this->customer->getId());
			if(!isset($store_detail['store_status'])){
				$json['status'] = 'error';
				$json['message'] = $this->language->get('seller_not_approved');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json)); 
			}
			if(!$this->pts->validateSeller()) {		
				$json['status'] = 'error';
				$json['message'] = $this->language->get('error_license');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			} 
			
			$this->load->language('extension/purpletree_multivendor/multivendor/shipping');
			$this->load->model('extension/purpletree_multivendor/multivendor/shipping');
			if ($this->request->server['REQUEST_METHOD'] == 'POST') {
				$requestjson2 = file_get_contents('php://input');
				$requestjson1 = json_decode($requestjson2, true);
				if($this->validateForm($requestjson1)) {
					$seller_id=$this->customer->getId();
					$this->model_extension_purpletree_multivendor_multivendor_shipping->addShipping($requestjson1,$seller_id);
					$this->session->data['success'] = $this->language->get('text_success_add');
					$json['status'] = 'success';
					$json['message'] =  $this->language->get('text_success_add');
				}
			}
			$json = $this->getForm();
			$this->response->addHeader('Content-Type: application/json');
			return $this->response->setOutput(json_encode($json));
		}
		
		public function delete() {
			$this->registry->set('pts', new  \PurpletreeMultivendor\System\Library\MyCustomLibrary($this->registry));
			$this->checkPlugin();
			$json = array();
			$this->load->language('extension/purpletree_multivendor/multivendor/api');
			if (!$this->pts->isMobileApiCall()) { 
				$json['status'] = 'error';
				$json['message'] = $this->language->get('error_permission');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			}
			if (!$this->customer->isLogged()) {
				$json['status'] = 'error';
				$json['message'] = $this->language->get('seller_not_logged');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			}
			
			$this->load->model('extension/purpletree_multivendor/multivendor/dashboard');
			$store_detail = $this->model_extension_purpletree_multivendor_multivendor_dashboard->isSeller($this->customer->getId());
			if(!isset($store_detail['store_status'])){
				$json['status'] = 'error';
				$json['message'] = $this->language->get('seller_not_approved');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json)); 
			}
			if(!$this->pts->validateSeller()) {		
				$json['status'] = 'error';
				$json['message'] = $this->language->get('error_license');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			} 
			
			$this->load->language('extension/purpletree_multivendor/multivendor/shipping');
			$this->load->model('extension/purpletree_multivendor/multivendor/shipping');
			
			if (isset($this->request->get['shipping_id']) ) {
				
				$this->model_extension_purpletree_multivendor_multivendor_shipping->deleteShipping($this->request->get['shipping_id']);
				
				$this->session->data['success'] = $this->language->get('text_success_delete');
				$json['status'] = 'success';
				$json['message'] =  $this->language->get('text_success_delete');
			}
			$this->response->addHeader('Content-Type: application/json');
			$this->response->setOutput(json_encode($json));
		}
		
		public function deletes() {
			$this->registry->set('pts', new  \PurpletreeMultivendor\System\Library\MyCustomLibrary($this->registry));
			$this->checkPlugin();
			$json = array();
			$this->load->language('extension/purpletree_multivendor/multivendor/api');
			if (!$this->pts->isMobileApiCall()) { 
				$json['status'] = 'error';
				$json['message'] = $this->language->get('error_permission');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			}
			if (!$this->customer->isLogged()) {
				$json['status'] = 'error';
				$json['message'] = $this->language->get('seller_not_logged');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			}
			
			$this->load->model('extension/purpletree_multivendor/multivendor/dashboard');
			$store_detail = $this->model_extension_purpletree_multivendor_multivendor_dashboard->isSeller($this->customer->getId());
			if(!isset($store_detail['store_status'])){
				$json['status'] = 'error';
				$json['message'] = $this->language->get('seller_not_approved');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json)); 
			}
			if(!$this->pts->validateSeller()) {		
				$json['status'] = 'error';
				$json['message'] = $this->language->get('error_license');
				$this->response->addHeader('Content-Type: application/json');
				return $this->response->setOutput(json_encode($json));
			} 
			
			$this->load->language('extension/purpletree_multivendor/multivendor/shipping');
			
			$this->document->setTitle($this->language->get('heading_title'));
			
			$this->load->model('extension/purpletree_multivendor/multivendor/shipping');
			
			if(!$this->pts->validateSeller()) {
				$this->load->language('extension/purpletree_multivendor/multivendor/ptsmultivendor');
				$this->session->data['error_warning'] = $this->language->get('error_license');			
				$this->response->redirect($this->url->link('extension/purpletree_multivendor/multivendor/shipping', '', true));
			}
			if (isset($this->request->post['selected'])) {
				foreach ($this->request->post['selected'] as $shipping_id) {
					$this->model_extension_purpletree_multivendor_multivendor_shipping->deleteShipping($shipping_id);
				}
				$this->session->data['success'] = $this->language->get('text_success_delete');
				$json['status'] = 'success';
				$json['message'] =  $this->language->get('text_success_delete');
			}
			$this->response->addHeader('Content-Type: application/json');
			$this->response->setOutput(json_encode($json));
		}
		
		protected function getList() {
			if (isset($this->request->get['filter_zip_from'])) {
				$filter_zip_from = $this->request->get['filter_zip_from'];
				} else {
				$filter_zip_from = '';
			}
			
			if (isset($this->request->get['filter_zip_to'])) {
				$filter_zip_to = $this->request->get['filter_zip_to'];
				} else {
				$filter_zip_to = '';
			}
			
			if (isset($this->request->get['page'])) {
				$page = $this->request->get['page'];
				} else {
				$page = 1;
			}
			/* if (isset($this->request->get['sort'])) {
				$sort = $this->request->get['sort'];
				} else {
				$sort = 'name';
				}
				
				if (isset($this->request->get['order'])) {
				$order = $this->request->get['order'];
				} else {
				$order = 'ASC';
				}
				
				if (isset($this->request->get['limit'])) {
				$limit = $this->request->get['limit'];
				} else {
				$limit = $this->config->get('config_limit_admin');
			} */
			
			$json['data']['sellers'] = array();
			
			$filter_data = array(
			'seller_id'       => $this->customer->getId(),
			//'filter_shipping_country'  => $filter_shipping_country,
			'filter_zip_from'          => $filter_zip_from,
			'filter_zip_to'            => $filter_zip_to,
			//'filter_price'             => $filter_price,
			//'filter_weight_from'       => $filter_weight_from,
			//'filter_weight_to'         => $filter_weight_to,
			//'sort'                     => $sort,
			//'order'                    => $order,
			'start'                    => ($page - 1) * 4,
			'limit'                    => 4
			);
			
			$shipping_total = $this->model_extension_purpletree_multivendor_multivendor_shipping->getTotalShipping($filter_data);		
			
			$results = $this->model_extension_purpletree_multivendor_multivendor_shipping->getShipping($filter_data);
			$curency = $this->config->get('config_currency');
			$this->load->model('extension/purpletree_multivendor/multivendor/dashboard');
			$currency_detail = $this->model_extension_purpletree_multivendor_multivendor_dashboard->getCurrencySymbol($curency);
			if(!empty($results)) {
				foreach ($results as $result) {
					
					$json['data']['sellers'][] = array(
					'shipping_id'    => $result['id'],
					'seller_id'    => $result['seller_id'],
					'shipping_country'          => $result['shipping_country'],
					'zipcode_from' => $result['zipcode_from'],
					'zipcode_to'         =>$result['zipcode_to'] ,
					'shipping_price'             => $this->currency->format($result['shipping_price'], $currency_detail['code'], $currency_detail['value']),
					'weight_from'             => $result['weight_from'],
					'weight_to'             => $result['weight_to']
					);
					$json['status'] = 'success';
				}
				} else {
				$json['status'] = 'success';
				$json['message'] = $this->language->get('no_data');
			}
			if (isset($this->error['warning'])) {
				$json['status'] = 'error';
				$json['message'] = $this->error['warning'];
				return $json;
			}
			
			if (isset($this->session->data['success'])) {
				$json['status'] = 'success';
				$json['message'] = $this->session->data['success'];
				
				unset($this->session->data['success']);
			}
			
			
			//$json['data']['pagination']['total'] = $shipping_total;
			//$json['data']['pagination']['page'] = $page;
			//$json['data']['pagination']['limit'] = $this->config->get('config_limit_admin');
			//$json['data']['results'] = sprintf($this->language->get('text_pagination'), ($shipping_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($shipping_total - $this->config->get('config_limit_admin'))) ? $shipping_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $shipping_total, ceil($shipping_total / $this->config->get('config_limit_admin')));
			
			
			//$json['data']['shipping_country'] = $filter_shipping_country;
			$json['data']['filter_zip_from'] = $filter_zip_from;
			$json['data']['filter_zip_to'] = $filter_zip_to;
			//$json['data']['filter_price'] = $filter_price;
			//$json['data']['filter_weight_from'] = $filter_weight_from;
			// $json['data']['filter_weight_to'] = $filter_weight_to;		
			//$this->load->model('localisation/country');
			// $json['data']['countries'] = $this->model_localisation_country->getCountries();
			//$json['data']['sort'] = $sort;
			//$json['data']['order'] = $order;
			
			return $json;
		}
		
		protected function getForm() {
			
			$json['data']['text_form'] = $this->language->get('text_add') ;
			$data['seller_id'] = $this->customer->getId();
			
			if (isset($this->error['warning'])) {
				$json['status'] = 'error';
				$json['message'] = $this->error['warning'];
				return $json;
				} else {
				$json['message'] = '';
			}
			
			if (isset($this->error['shipping_country'])) {
				$json['status'] = 'error';
				$json['message'] = $this->error['shipping_country']; 
				return $json;
				} else {
				$json['message'] = '';
			}
			
			if (isset($this->error['zip_from'])) {
				$json['status'] = 'error';
				$json['message'] = $this->error['zip_from']; 
				return $json;
				} else {
				$json['message'] = '';
			}
			
			if (isset($this->error['zip_to'])) {
				$json['status'] = 'error';
				$json['message'] = $this->error['zip_to']; 
				return $json;
				} else {
				$json['message'] = '';
			}
			
			if (isset($this->error['price'])) {
				$json['status'] = 'error';
				$json['message'] = $this->error['price']; 
				return $json;
				} else {
				$json['message'] = '';
			}
			
			if (isset($this->error['weight_from'])) {
				$json['status'] = 'error';
				$json['message'] = $this->error['weight_from']; 
				return $json;
				} else {
				$json['message'] = '';
			}
			
			if (isset($this->error['weight_to'])) {
				$json['status'] = 'error';
				$json['message'] = $this->error['weight_to']; 
				return $json;
				} else {
				$json['message'] = '';
			}
			
			$json['status'] = 'success';
			return $json;
		}
		
		protected function validateForm($requestjson1) {
			
			if (($requestjson1['shipping_country'])== '') {
				$this->error['shipping_country'] = $this->language->get('error_shipping_country');
			}
			
			if ((strlen($requestjson1['zip_from']) < 1) ) {
				$this->error['zip_from'] = $this->language->get('error_zipcode');
			}
			
			if ((strlen($requestjson1['zip_to']) < 1) ) {
				$this->error['zip_to'] = $this->language->get('error_zipcode');
			}
			
			if( ! filter_var($requestjson1['price'], FILTER_VALIDATE_FLOAT) && $requestjson1['price'] != '0') {
				$this->error['price'] = $this->language->get('error_valid_value');
			}
			if(strlen($requestjson1['price']) < 1){  
				$this->error['price'] = $this->language->get('error_shipping_price');
			}
			
			if( ! filter_var($requestjson1['weight_from'], FILTER_VALIDATE_FLOAT) && $requestjson1['weight_from'] != '0' ){
				$this->error['weight_from'] = $this->language->get('error_valid_value');
			}
			if(strlen($requestjson1['weight_from']) < 1){
				$this->error['weight_from'] = $this->language->get('error_weight');
			}
			
			if( ! filter_var($requestjson1['weight_to'], FILTER_VALIDATE_FLOAT) && $requestjson1['weight_to'] != '0' ){
				
				$this->error['weight_to'] = $this->language->get('error_valid_value');
			}		
			if($requestjson1['weight_to'] < $requestjson1['weight_from']) {
				$this->error['weight_to'] = $this->language->get('error_weight_to');
			}
			if(strlen($requestjson1['weight_to'] ) < 1){
				$this->error['weight_to'] = $this->language->get('error_weight');
			}
			return !$this->error; 
		}
		
		private function checkPlugin() {
			header('Access-Control-Allow-Origin:*');
			header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
			header('Access-Control-Max-Age: 286400');
			header('Access-Control-Allow-Credentials: true');
			header('Access-Control-Allow-Headers: languageid,LANGUAGEID,Languageid,languageid,LANGUAGEID,Languageid,purpletreemultivendor,Purpletreemultivendor,PURPLETREEMULTIVENDOR,xocmerchantid,XOCMERCHANTID,Xocmerchantid,XOCSESSION,xocsession,Xocsession,content-type,CONTENT-TYPE,Content-Type');
		}
}