<?php


namespace Shiperr;

class Location
{

	public static function sendRequest(string $url){
		$apiEndpoint = Shiperr::$baseUrl . '/v3/location';

		// $queryParams = http_build_query([
	    //     'adm_level' => $adm_level,
	    //     'keyword' => $keyword
	    // ]);

	    // $url = $apiEndpoint . '?' . $queryParams;
	    $ch = curl_init();
	    curl_setopt($ch, CURLOPT_URL, $url);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	    curl_setopt($ch, CURLOPT_HTTPHEADER, [
	    	'Accept: application/json',
	        'X-API-Key: '. Shiperr::$apiKey,
	    ]);
	    $response = curl_exec($ch);
	    curl_close($ch);

	    return json_decode($response);
	}

	public static function getCountries(string $url) : object
    {
		return self::sendRequest($url);
    }

    public static function getProvinces(string $url) : object
    {
		return self::sendRequest($url);
    }

    public static function getCities(string $url) : object
    {
		return self::sendRequest($url);
    }

    public static function getSuburb(string $url) : object
    {
		return self::sendRequest($url);
    }

    public static function getAreas(string $url) : object
    {
		return self::sendRequest($url);
    }

    public static function getInsertAll() : object
    {
    	$url_country = 'https://merchant-api-sandbox.shipper.id/v3/location/countries';

    	$countries = self::getCountries($url_country);
    	$message = array(
    		'message' => 'Success'
    	);
    	$servername = "localhost";
		$username = "root";
		$password = "";
		$dbname = "ecom2024";
		try {
			$conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);

	    	foreach ($countries['countries'] as $country) {
	    		#query insert Country
	    		$query_country = "INSERT INTO countries (id, name, code) VALUES (:id, :name, :code)";
				$connection_country = $conn->prepare($query_country);
			    $connection_country->bindParam(':id', $country['id']);
			    $connection_country->bindParam(':name', $country['name']);
			    $connection_country->bindParam(':code', $country['code']);

			    $connection_country->execute();

	    		#get province
				$url_province = 'https://merchant-api-sandbox.shipper.id/v3/location/countries/'.$country['id'].'/provinces';
				$provinces = self::getProvinces($url_province);

				foreach ($provinces as $province){
					#query insert Provice
					$query_provinces = "INSERT INTO provinces (id, countries_id, name, lat, lng) VALUES (:id,:countries_id, :name, :lat, :lng)";

					$connection_provinces = $conn->prepare($query_provinces);
				    $connection_provinces->bindParam(':id', $provinces['id']);
				    $connection_provinces->bindParam(':countries_id', $country['id']);
				    $connection_provinces->bindParam(':name', $provinces['name']);
					$connection_provinces->bindParam(':lat', $provinces['lat']);
					$connection_provinces->bindParam(':lng', $provinces['lng']);
				    $connection_provinces->execute();

					#get cities
					$url_cities = 'https://merchant-api-sandbox.shipper.id/v3/location/province/'.$province['id'].'/cities';
					$cities = self::getCities($url_cities);

					foreach ($cities as $city){
						#query insert Cities
						$query_cities = "INSERT INTO cities (id, provinces_id, name, lat, lng) VALUES (:id,:provinces_id, :name, :lat, :lng)";
						$connection_cities = $conn->prepare($query_cities);
					    $connection_cities->bindParam(':id', $city['id']);
					    $connection_cities->bindParam(':provinces_id', $province['id']);
					    $connection_cities->bindParam(':name', $city['name']);
						$connection_cities->bindParam(':lat', $city['lat']);
						$connection_cities->bindParam(':lng', $city['lng']);
					    $connection_cities->execute();
						#get suburbs
						$url_suburbs = 'https://merchant-api-sandbox.shipper.id/v3/location/city/'.$city['id'].'/suburbs';
						$suburbs = self::getSuburb($url_suburbs);

						foreach ($suburbs as $suburb){
							#query insert Suburbs
							$query_suburbs = "INSERT INTO suburbs (id, cities_id, name, lat, lng) VALUES (:id,:cities_id, :name, :lat, :lng)";

							$connection_suburbs = $conn->prepare($query_suburbs);
						    $connection_suburbs->bindParam(':id', $suburb['id']);
						    $connection_suburbs->bindParam(':cities_id', $city['id']);
						    $connection_suburbs->bindParam(':name', $suburb['name']);
							$connection_suburbs->bindParam(':lat', $suburb['lat']);
							$connection_suburbs->bindParam(':lng', $suburb['lng']);
						    $connection_suburbs->execute();

							#get areas
							$url_areas = 'https://merchant-api-sandbox.shipper.id/v3/location/suburb/'.$suburb['id'].'/areas';
							$areas = self::getAreas($url_areas);
							foreach ($areas as $area){
								#query insert Areas
								$query_areas = "INSERT INTO areas (id, suburbs_id, name, lat, lng, postcode) VALUES (:id,:suburbs_id, :name, :lat, :lng, :postcode)";
							
								$connection_areas = $conn->prepare($query_areas);
							    $connection_areas->bindParam(':id', $area['id']);
							    $connection_areas->bindParam(':suburbs_id', $suburb['id']);
							    $connection_areas->bindParam(':name', $area['name']);
								$connection_areas->bindParam(':lat', $area['lat']);
								$connection_areas->bindParam(':lng', $area['lng']);
								$connection_areas->bindParam(':postcode', $area['postcode']);
							    $connection_areas->execute();
							}
						}
					}
				}
	    	}
	    } catch(PDOException $e) {
		    echo "Connection failed: " . $e->getMessage();
		}

		$conn = null;


		return $message;
    }

}