<?php
namespace Shiperr;

class Pickup
{
	public static function createPickup(string $orderId){
		$url = Shiperr::$baseUrl . '/v3/pickup';

		$request_data = [
		    "data" => [
		        "order_activation" => [
		            "order_id" => [$orderId]
		        ]
		    ]
		];

		$data = json_encode($request_data);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    curl_setopt($ch, CURLOPT_HTTPHEADER, [
	    	'Accept: application/json',
	        'X-API-Key: '. Shiperr::$apiKey,
	    ]);
	    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	    $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);

	    if ($error) {
            throw new Exception('cURL Error: ' . $error);
        }
 		return json_decode($response);
	}

}