<?php
namespace Opencart\Catalog\Controller\Extension\SoTheme\SimpleBlog;
require_once (DIR_EXTENSION.'so_theme/admin/view/template/soconfig/class/soconfig.php');
	class Article extends \Opencart\System\Engine\Controller {	
		public function index() {
			$this->load->language('extension/so_theme/simple_blog/article','',$this->config->get('config_language'));
			$data['error_no_database'] = '';
			
			if(!$this->checkDatabase()) {
				if($this->config->has('simple_blog_heading')) {
					$this->document->setTitle($this->config->get('simple_blog_heading'));
				} else {
					$this->document->setTitle($this->language->get('heading_title'));
				}
				$this->document->addStyle('extension/so_theme/catalog/view/javascript/simple_blog/css/style.css');
				
				$this->load->model('extension/so_theme/simple_blog/article');
				
				$this->load->model('tool/image');


				if($this->config->get('simple_blog_heading')) {
					$data['heading_title'] = $this->config->get('simple_blog_heading');
				} else {
					$data['heading_title'] = $this->language->get('heading_title');
				}
				
				$data['articles'] = array();
				
				if (isset($this->request->get['blog_search'])) {
					$blog_search = $this->request->get['blog_search'];
				} else { 
					$blog_search = '';
				}	
				
				
				if (isset($this->request->get['page'])) {
					$page = $this->request->get['page'];
				} else { 
					$page = 1;
				}		
				
				if (isset($this->request->get['limit'])) {
					$limit = $this->request->get['limit'];
				} else {
					$limit = 10;
				}
				
				$filter_data = array(
					'blog_search'	=> $blog_search,
					'start'	=> ($page - 1) * $limit,
					'limit'	=> $limit
				);
				
				$blog_total = $this->model_extension_so_theme_simple_blog_article->getTotalArticle($filter_data);
				
				$results = $this->model_extension_so_theme_simple_blog_article->getArticles($filter_data);
				
				//print "<pre>"; print_r($results); exit;
				
				foreach($results as $result) {
					
					$description = substr(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')), 0, 150) . '...';
					
					if ($result['featured_image']) {
						$image = HTTP_SERVER . 'image/' . $result['featured_image'];
						$featured_found = 1;

					} else if($result['image']) {
						$image = HTTP_SERVER . 'image/' . $result['image'];
						$featured_found = '';
					} else {
						//$image = false;
						$image = $this->model_tool_image->resize('placeholder.png', 600, 390);
						$featured_found = false;
					   
					}
					
					// get total comments
					$total_comments = $this->model_extension_so_theme_simple_blog_article->getTotalComments($result['simple_blog_article_id']);
					
					if($total_comments != 1) {
						$total_comments .= $this->language->get('text_comments');
					} else {
						$total_comments .= $this->language->get('text_comment');
					}


					$data['articles'][] = array(
						'simple_blog_article_id'	=> $result['simple_blog_article_id'],
						'article_title'		=> $result['article_title'],
						'author_name'		=> $result['author_name'],
						'image'				=> $image,
						'featured_found'	=> $featured_found,
						'date_added'		=> date($this->language->get('text_date_format'), strtotime($result['date_modified'])),
						'description'		=> $description,
						'allow_comment'		=> $result['allow_comment'],
						'total_comment'		=> $total_comments,
						'href'				=> $this->url->link('extension/so_theme/simple_blog/article_info', 'language=' . $this->config->get('config_language') . '&simple_blog_article_id=' . $result['simple_blog_article_id'], true),
						'author_href'		=> $this->url->link('extension/so_theme/simple_blog/author', 'simple_blog_author_id=' . $result['simple_blog_author_id'], true),
						'comment_href'		=> $this->url->link('extension/so_theme/simple_blog/article_info', 'simple_blog_article_id=' . $result['simple_blog_article_id'], true)
					);
				}			
				
				$pagination = $this->load->controller('common/pagination', [
						'total' => $blog_total,
						'page'  => $page,
						'limit' => $limit,
						'text'  => $this->language->get('text_pagination'),
						'url'   => $this->url->link('extension/so_theme/simple_blog/article' , 'language=' . $this->config->get('config_language') . '&page={page}'),
				]);
				
				$data['pagination'] = $pagination;				
				
				$data['results'] = sprintf($this->language->get('text_pagination'), ($blog_total) ? (($page - 1) * $limit) + 1 : 0, ((($page - 1) * $limit) > ($blog_total - $limit)) ? $blog_total : ((($page - 1) * $limit) + $limit), $blog_total, ceil($blog_total / $limit));
				//print "<pre>"; print_r($data['articles']); exit;
			}else{
				$data['error_no_database'] = $this->language->get('text_no_database');
				
			}		
				$data['button_continue_reading'] = $this->language->get('button_continue_reading');
				$data['text_no_found'] = $this->language->get('text_no_found');
				
				$data['breadcrumbs'] = array();

				$data['breadcrumbs'][] = array(
					'text'      => $this->language->get('text_home'),
					'href'      => $this->url->link('common/home'),
					'separator' => false
				);
		
				$data['breadcrumbs'][] = array(
					'text'      => $this->language->get('heading_title'),
					'href'      => $this->url->link('extension/so_theme/simple_blog/article'),       		
					'separator' => ' :: '
				);
				
			
				$data['column_left'] = $this->load->controller('common/column_left');
				$data['column_right'] = $this->load->controller('common/column_right');
				$data['content_top'] = $this->load->controller('common/content_top');
				$data['content_bottom'] = $this->load->controller('common/content_bottom');
				$data['footer'] = $this->load->controller('common/footer');
				$data['header'] = $this->load->controller('common/header');
				$data['right_blog'] = $this->load->controller('common/right_blog');

				$soconfig = new \ClassSoconfig($this->registry); 
				$platforms_mobile 		= $soconfig->get_settings('platforms_mobile');	
				if($this->session->data['device']=='mobile' && $platforms_mobile) {
					$this->response->setOutput($this->load->view('extension/so_theme/somobile/template/simple_blog/article', $data));
				} else {
					$this->response->setOutput($this->load->view('extension/so_theme/simple_blog/article', $data));
				}		
        }
		
		public function checkDatabase() {
			$database_not_found = $this->validateTable();

			if(!$database_not_found) {
				return true;
			}
			return false;
		}
		
		public function validateTable() {
			$table_name = $this->db->escape('simple_blog_article');

			$table = DB_PREFIX . $table_name;

			$query = $this->db->query("SHOW TABLES LIKE '{$table}'");

			return $query->num_rows;
		}
		
		
		public function comment() {
			$this->load->language('extension/so_theme/simple_blog/article','',$this->config->get('config_language'));
	
			$this->load->model('extension/so_theme/simple_blog/article');
	
			$data['text_on'] = $this->language->get('text_on');
			$data['text_said'] = $this->language->get('text_said');
			$data['text_no_blog'] = $this->language->get('text_no_blog');
	
			if (isset($this->request->get['page'])) {
				$page = $this->request->get['page'];
			} else {
				$page = 1;
			}
			
			$data['text_reply_comment'] = $this->language->get('text_reply_comment');
			
			$data['comments'] = array();
	
			$comment_total = $this->model_extension_so_theme_simple_blog_article->getTotalCommentsByArticleId($this->request->get['simple_blog_article_id']);
	
			$results = $this->model_extension_so_theme_simple_blog_article->getCommentsByArticle($this->request->get['simple_blog_article_id'],($page - 1) * 10, 10, 0);
			
			//print "<pre>"; print_r($results); exit;
			
			foreach ($results as $result) {
				
				$comment_reply = '';
				$comment_replies = array();
				$comment_reply = $this->model_extension_so_theme_simple_blog_article->getCommentsByArticle($this->request->get['simple_blog_article_id'], 0, 1000, $result['simple_blog_comment_id']);
				
                foreach($comment_reply as $comment) {
                    $comment_replies[] = array(
                        'author'    => $comment['author'],
                        'date_added'    => date($this->language->get('text_date_format_long'), strtotime($comment['date_added'])),
                        'comment'       => $comment['comment']
                    );
                }
                
				$data['comments'][] = array(
					'simple_blog_article_id' 	=> $result['simple_blog_article_id'],
					'simple_blog_comment_id' 	=> $result['simple_blog_comment_id'],
					'comment_reply'		=> $comment_replies,
					'author'     		=> ucwords($result['author']),
					'comment'       	=> $result['comment'],
					'date_added' 		=> date($this->language->get('text_date_format_long'), strtotime($result['date_added']))
				);
			}

			//print "<pre>"; print_r($data['comments']); exit;
			$pagination = $this->load->controller('common/pagination', [
					'total' => $comment_total,
					'page'  => $page,
					'limit' => 5,
					'text'  => $this->language->get('text_pagination'),
					'url'   => $this->url->link('extension/so_theme/simple_blog/article/comment', 'simple_blog_article_id=' . $this->request->get['simple_blog_article_id'] . '&page={page}'),
			]);
			
			$data['pagination'] = $pagination;			
			
            
            $data['results'] = sprintf($this->language->get('text_pagination'), ($comment_total) ? (($page - 1) * 5) + 1 : 0, ((($page - 1) * 5) > ($comment_total - 5)) ? $comment_total : ((($page - 1) * 5) + 5), $comment_total, ceil($comment_total / 5));

			$soconfig = new \ClassSoconfig($this->registry); 
			$platforms_mobile 		= $soconfig->get_settings('platforms_mobile');
			if($this->session->data['device']=='mobile' && $platforms_mobile) {
				$this->response->setOutput($this->load->view('extension/so_theme/somobile/template/simple_blog/article_comment', $data));
			} else {
				$this->response->setOutput($this->load->view('extension/so_theme/simple_blog/article_comment', $data));
			}
        }
		
		public function writeComment() {
			
			$this->load->model('extension/so_theme/simple_blog/article');
			
			$this->load->language('extension/so_theme/simple_blog/article','',$this->config->get('config_language'));
			
			$json = array();


			if ($this->request->server['REQUEST_METHOD'] == 'POST') {
				
				if ((strlen($this->request->post['name']) < 3) || (strlen($this->request->post['name']) > 25)) {
					$json['error'] = $this->language->get('error_name');
				}
	
				if ((strlen($this->request->post['text']) < 3) || (strlen($this->request->post['text']) > 1000)) {
					$json['error'] = $this->language->get('error_text');
				}
	
				if ($this->config->get($this->config->get('config_captcha') . '_status') && in_array('register', (array)$this->config->get('config_captcha_page'))) {
					$captcha = $this->load->controller('extension/captcha/' . $this->config->get('config_captcha') . '/validate');

					if ($captcha) {
						$json['error'] = $captcha;
					}
				}
				
				if (!isset($json['error'])) {
					//print_r($this->request->post); exit;
					$this->model_extension_so_theme_simple_blog_article->addArticleComment($this->request->get['simple_blog_article_id'], $this->request->post);
					
					if($this->config->get('simple_blog_comment_auto_approval')) {
						$json['success'] = $this->language->get('text_success');	
					} else {
						$json['success'] = $this->language->get('text_success_approval');	
					}				

				}				
			}
			
			$this->response->setOutput(json_encode($json));
		}
	}